<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Information about cardholder possession validation and cardholder identification and verifications
 * (ID&V).
 */
class AssuranceDetails implements \JsonSerializable
{
    /**
     * @var bool|null
     */
    private $accountVerified = false;

    /**
     * @var bool|null
     */
    private $cardHolderAuthenticated = false;

    /**
     * Returns Account Verified.
     * If true, indicates that Cardholder possession validation has been performed on returned payment
     * credential.
     */
    public function getAccountVerified(): ?bool
    {
        return $this->accountVerified;
    }

    /**
     * Sets Account Verified.
     * If true, indicates that Cardholder possession validation has been performed on returned payment
     * credential.
     *
     * @maps account_verified
     */
    public function setAccountVerified(?bool $accountVerified): void
    {
        $this->accountVerified = $accountVerified;
    }

    /**
     * Returns Card Holder Authenticated.
     * If true, indicates that identification and verifications (ID&V) was performed on the returned
     * payment credential.If false, the same risk-based authentication can be performed as you would for
     * card transactions. This risk-based authentication can include, but not limited to, step-up with 3D
     * Secure protocol if applicable.
     */
    public function getCardHolderAuthenticated(): ?bool
    {
        return $this->cardHolderAuthenticated;
    }

    /**
     * Sets Card Holder Authenticated.
     * If true, indicates that identification and verifications (ID&V) was performed on the returned
     * payment credential.If false, the same risk-based authentication can be performed as you would for
     * card transactions. This risk-based authentication can include, but not limited to, step-up with 3D
     * Secure protocol if applicable.
     *
     * @maps card_holder_authenticated
     */
    public function setCardHolderAuthenticated(?bool $cardHolderAuthenticated): void
    {
        $this->cardHolderAuthenticated = $cardHolderAuthenticated;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->accountVerified)) {
            $json['account_verified']          = $this->accountVerified;
        }
        if (isset($this->cardHolderAuthenticated)) {
            $json['card_holder_authenticated'] = $this->cardHolderAuthenticated;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
