<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaymentCollection;

/**
 * Builder for model PaymentCollection
 *
 * @see PaymentCollection
 */
class PaymentCollectionBuilder
{
    /**
     * @var PaymentCollection
     */
    private $instance;

    private function __construct(PaymentCollection $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new payment collection Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentCollection());
    }

    /**
     * Sets authorizations field.
     */
    public function authorizations(?array $value): self
    {
        $this->instance->setAuthorizations($value);
        return $this;
    }

    /**
     * Sets captures field.
     */
    public function captures(?array $value): self
    {
        $this->instance->setCaptures($value);
        return $this;
    }

    /**
     * Sets refunds field.
     */
    public function refunds(?array $value): self
    {
        $this->instance->setRefunds($value);
        return $this;
    }

    /**
     * Initializes a new payment collection object.
     */
    public function build(): PaymentCollection
    {
        return CoreHelper::clone($this->instance);
    }
}
