<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CustomerRequest;
use PaypalServerSdkLib\Models\PaymentTokenResponse;
use PaypalServerSdkLib\Models\PaymentTokenResponsePaymentSource;

/**
 * Builder for model PaymentTokenResponse
 *
 * @see PaymentTokenResponse
 */
class PaymentTokenResponseBuilder
{
    /**
     * @var PaymentTokenResponse
     */
    private $instance;

    private function __construct(PaymentTokenResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new payment token response Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentTokenResponse());
    }

    /**
     * Sets id field.
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets customer field.
     */
    public function customer(?CustomerRequest $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Sets payment source field.
     */
    public function paymentSource(?PaymentTokenResponsePaymentSource $value): self
    {
        $this->instance->setPaymentSource($value);
        return $this;
    }

    /**
     * Sets links field.
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new payment token response object.
     */
    public function build(): PaymentTokenResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
