<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaypalWalletAttributes;
use PaypalServerSdkLib\Models\PaypalWalletCustomerRequest;
use PaypalServerSdkLib\Models\PaypalWalletVaultInstruction;

/**
 * Builder for model PaypalWalletAttributes
 *
 * @see PaypalWalletAttributes
 */
class PaypalWalletAttributesBuilder
{
    /**
     * @var PaypalWalletAttributes
     */
    private $instance;

    private function __construct(PaypalWalletAttributes $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new paypal wallet attributes Builder object.
     */
    public static function init(): self
    {
        return new self(new PaypalWalletAttributes());
    }

    /**
     * Sets customer field.
     */
    public function customer(?PaypalWalletCustomerRequest $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Sets vault field.
     */
    public function vault(?PaypalWalletVaultInstruction $value): self
    {
        $this->instance->setVault($value);
        return $this;
    }

    /**
     * Initializes a new paypal wallet attributes object.
     */
    public function build(): PaypalWalletAttributes
    {
        return CoreHelper::clone($this->instance);
    }
}
