<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Supplementary data about a payment. This object passes information that can be used to improve risk
 * assessments and processing costs, for example, by providing Level 2 and Level 3 payment data.
 */
class SupplementaryData implements \JsonSerializable
{
    /**
     * @var CardSupplementaryData|null
     */
    private $card;

    /**
     * Returns Card.
     * Merchants and partners can add Level 2 and 3 data to payments to reduce risk and payment processing
     * costs. For more information about processing payments, see <a href="https://developer.paypal.
     * com/docs/checkout/advanced/processing/">checkout</a> or <a href="https://developer.paypal.
     * com/docs/multiparty/checkout/advanced/processing/">multiparty checkout</a>.
     */
    public function getCard(): ?CardSupplementaryData
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * Merchants and partners can add Level 2 and 3 data to payments to reduce risk and payment processing
     * costs. For more information about processing payments, see <a href="https://developer.paypal.
     * com/docs/checkout/advanced/processing/">checkout</a> or <a href="https://developer.paypal.
     * com/docs/multiparty/checkout/advanced/processing/">multiparty checkout</a>.
     *
     * @maps card
     */
    public function setCard(?CardSupplementaryData $card): void
    {
        $this->card = $card;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->card)) {
            $json['card'] = $this->card;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
